/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.KeywordException;
import com.ibm.hwmca.base.updates.MCF;
import com.ibm.hwmca.base.updates.MCFLine;
import com.ibm.hwmca.base.updates.McfCommand;
import com.ibm.hwmca.base.updates.McfKeyword;
import com.ibm.hwmca.base.updates.McfKeywordEvent;
import com.ibm.hwmca.base.updates.McfKeywordListener;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public final class BaseMcfKeywordListener
implements McfKeywordListener,
UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCFBKLT";
    private static final String TRACE_MASKF = "XMCFBKLF";
    private static final String TRACE_MASKD = "XMCFBKLD";
    private static final String TRACE_CLASS = "BaseMcfKeywordListener";
    private static final String TRACE_IN = "-> ";
    private static final String TRACE_OUT = "<- ";
    private static final String TRACE_INOUT = "<> ";
    private static final String TRACE_OTHER = "   ";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "BsMcfKeyLstr");
    private static final String KEYWORD_AEXEC = "AEXEC";
    private static final String KEYWORD_DEXEC = "DEXEC";
    private static final String KEYWORD_APPLY_NOW = "APPLY_NOW";
    private static final String KEYWORD_APPLY_REBOOT = "FORCE_SP_REBOOT";
    private static final String KEYWORD_EC = "EC";
    private static final String KEYWORD_ACCEPT = "ACCEPT";
    private static final String[] interestingKeywordNames = new String[]{"AEXEC", "DEXEC", "EC", "ACCEPT", "APPLY_NOW", "FORCE_SP_REBOOT"};
    private static final List interestingKeywords = Arrays.asList(interestingKeywordNames);
    private static BaseMcfKeywordListener theBaseMcfKeywordListener = null;

    public static synchronized BaseMcfKeywordListener getBaseMcfKeywordListener() {
        String TRACE_METHOD = ".getBaseMcfKeywordListener()";
        Trace.trace(TRACE_MASKT, "-> BaseMcfKeywordListener" + TRACE_METHOD);
        if (theBaseMcfKeywordListener == null) {
            theBaseMcfKeywordListener = new BaseMcfKeywordListener();
        }
        Trace.trace(TRACE_MASKT, "<- BaseMcfKeywordListener" + TRACE_METHOD);
        return theBaseMcfKeywordListener;
    }

    private BaseMcfKeywordListener() {
        String TRACE_METHOD = ".()";
        Trace.trace(TRACE_MASKT, "<> BaseMcfKeywordListener" + TRACE_METHOD);
    }

    public void processCommand(McfKeyword keyword, MCF mcf, String type) {
        McfCommand newCommand;
        String TRACE_METHOD = ".processCommand()";
        Trace.trace(TRACE_MASKT, "-> BaseMcfKeywordListener" + TRACE_METHOD);
        StringTokenizer tokens = new StringTokenizer(keyword.getInputString(), "*= \t\n\r\f");
        if (tokens.hasMoreTokens()) {
            tokens.nextToken().toUpperCase();
        }
        String command = "";
        if (tokens.hasMoreTokens()) {
            command = tokens.nextToken();
        }
        while (tokens.hasMoreTokens()) {
            command = command + " " + tokens.nextToken();
        }
        Trace.trace(TRACE_MASKF, "   BaseMcfKeywordListener" + TRACE_METHOD + " - command string is [" + command + "]");
        if (type.equals(KEYWORD_AEXEC)) {
            newCommand = new McfCommand(1, command);
            mcf.addToAExecList(newCommand);
        }
        if (type.equals(KEYWORD_DEXEC)) {
            newCommand = new McfCommand(2, command);
            mcf.addToDExecList(newCommand);
        }
        Trace.trace(TRACE_MASKT, "<- BaseMcfKeywordListener" + TRACE_METHOD);
    }

    public void processEqualsKeyword(McfKeyword keyword, MCF mcf) {
        String TRACE_METHOD = ".processGenericKeyword()";
        Trace.trace(TRACE_MASKT, "-> BaseMcfKeywordListener" + TRACE_METHOD);
        String work = keyword.getInputString();
        int pos = work.indexOf(61);
        if (pos < 0) {
            String msg = "Keyword error (no '='): " + keyword;
            Trace.trace(TRACE_MASKF, "   BaseMcfKeywordListener" + TRACE_METHOD + " - " + msg);
            throw new KeywordException(msg);
        }
        StringTokenizer tokens = new StringTokenizer(work, "*= \t\n\r\f");
        String betterBeKeyword = "";
        if (tokens.hasMoreTokens()) {
            betterBeKeyword = tokens.nextToken().toUpperCase();
        }
        if (!keyword.getKeyword().equals(betterBeKeyword)) {
            String msg = "Keyword error ('=' in wrong place): " + keyword;
            Trace.trace(TRACE_MASKF, "   BaseMcfKeywordListener" + TRACE_METHOD + " - " + msg);
            throw new KeywordException(msg);
        }
        String value = "";
        if (tokens.hasMoreTokens()) {
            value = tokens.nextToken().toUpperCase();
        }
        if (value.equals("")) {
            String msg = "Keyword error (no value after '='): " + keyword;
            Trace.trace(TRACE_MASKF, "   BaseMcfKeywordListener" + TRACE_METHOD + " - " + msg);
            throw new KeywordException(msg);
        }
        if (tokens.hasMoreTokens()) {
            String msg = "Keyword error (illegal value after '='): " + keyword;
            Trace.trace(TRACE_MASKF, "   BaseMcfKeywordListener" + TRACE_METHOD + " - " + msg);
            throw new KeywordException(msg);
        }
        MCFLine command = new MCFLine(keyword.getKeyword(), value);
        if (255 == command.getCommand()) {
            String msg = "Keyword error: " + keyword;
            Trace.trace(TRACE_MASKF, "   BaseMcfKeywordListener" + TRACE_METHOD + " - " + msg);
            throw new KeywordException(msg);
        }
        mcf.addToCommandsList(command);
        Trace.trace(TRACE_MASKT, "<- BaseMcfKeywordListener" + TRACE_METHOD);
    }

    public void processGenericKeyword(McfKeyword keyword, MCF mcf) {
        String TRACE_METHOD = ".processGenericKeyword()";
        Trace.trace(TRACE_MASKT, "-> BaseMcfKeywordListener" + TRACE_METHOD);
        MCFLine command = new MCFLine(keyword.getKeyword(), "");
        if (255 == command.getCommand()) {
            String msg = "Keyword error: " + keyword;
            Trace.trace(TRACE_MASKF, "   BaseMcfKeywordListener" + TRACE_METHOD + " - " + msg);
            throw new KeywordException(msg);
        }
        mcf.addToCommandsList(command);
        Trace.trace(TRACE_MASKT, "<- BaseMcfKeywordListener" + TRACE_METHOD);
    }

    public void keywordDiscovered(McfKeyword keyword, MCF mcf) {
        String TRACE_METHOD = ".keywordDiscovered()";
        Trace.trace(TRACE_MASKT, "-> BaseMcfKeywordListener" + TRACE_METHOD);
        if (null != keyword && null != mcf) {
            Trace.trace(TRACE_MASKT, "   BaseMcfKeywordListener" + TRACE_METHOD + " - keyword is " + keyword + ", MCF is " + mcf.getDisplayableName());
            String key = keyword.getKeyword();
            if (interestingKeywords.contains(key)) {
                Trace.trace(TRACE_MASKF, "   BaseMcfKeywordListener" + TRACE_METHOD + " - processing " + keyword);
                if (key.equals(KEYWORD_AEXEC)) {
                    this.processCommand(keyword, mcf, KEYWORD_AEXEC);
                } else if (key.equals(KEYWORD_DEXEC)) {
                    this.processCommand(keyword, mcf, KEYWORD_DEXEC);
                } else if (key.equals(KEYWORD_EC)) {
                    this.processEqualsKeyword(keyword, mcf);
                } else if (key.equals(KEYWORD_ACCEPT)) {
                    this.processEqualsKeyword(keyword, mcf);
                } else {
                    this.processGenericKeyword(keyword, mcf);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- BaseMcfKeywordListener" + TRACE_METHOD);
    }

    public void keywordExecuted(McfKeyword keyword, MCF mcf) {
        String TRACE_METHOD = ".keywordExecuted()";
        Trace.trace(TRACE_MASKT, "-> BaseMcfKeywordListener" + TRACE_METHOD);
        if (null != keyword && null != mcf) {
            Trace.trace(TRACE_MASKT, "   BaseMcfKeywordListener" + TRACE_METHOD + " - keyword is " + keyword + ", MCF is " + mcf.getDisplayableName());
            String msg = "Unexpected keyword";
            throw new KeywordException(msg);
        }
        String msg = "Missing keyword or MCF";
        throw new KeywordException(msg);
    }

    public void keywordEvent(McfKeywordEvent event) {
        String TRACE_METHOD = ".keywordEvent()";
        Trace.trace(TRACE_MASKT, "-> BaseMcfKeywordListener" + TRACE_METHOD);
        Trace.trace(TRACE_MASKT, "<- BaseMcfKeywordListener" + TRACE_METHOD);
    }
}

